%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FileName:            mfSSCGenerate.m
%  Description:         ɸͬ
%  Reference:           3GPP TS 25.213, 5.2.3 Synchronisation codes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Parameter List:       
%       Output Parameter
%           SSC         ɵ16鸨ͬ
%       Input Parameter
%           
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  History
%    1. Date:           2017-12-1
%       Author:         david.lee
%       Version:        1.0 
%       Modification:   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [SSC] = mfSSCGenerate()   
%% ʼ
SSC = zeros(16, 256);
x = [1, 1, 1, 1, 1, 1, -1, -1, 1, -1, 1, -1, 1, -1, -1, 1];     %ͬ3GPP TS 25.213 5.2.3.1ax
b = zeros(1, 16);                                               %#ok ͬ3GPP TS 25.213 5.2.3.1b
z = zeros(1, 256);                                              %#ok ͬ3GPP TS 25.213 5.2.3.1z
H0 = 1;                                                         %#ok HadamardУͬ3GPP TS 25.213 5.2.3.1Hk
H1 = zeros(2, 2);                                               %#ok
H2 = zeros(4, 4);                                               %#ok
H3 = zeros(8, 8);                                               %#ok
H4 = zeros(16, 16);                                             %#ok
H5 = zeros(32, 32);                                             %#ok                    
H6 = zeros(64, 64);                                             %#ok
H7 = zeros(128, 128);                                           %#ok
H8 = zeros(256, 256);                                           %#ok
h=zeros(16,256);                                                %ͬ3GPP TS 25.213 5.2.3.1hn
m=[0,16,32,48,64,80,96,112,128,144,160,176,192,208,224,240];    %ͬ3GPP TS 25.213 5.2.3.1m = 16( k C 1)

%% ʵ
%z
b = [x(1), x(2), x(3), x(4), x(5), x(6), x(7), x(8), -x(9), -x(10), -x(11), -x(12), -x(1), -x(13), -x(14), -x(15)];
z = [b, b, b, -b, b, b, -b, -b, b, -b, b, -b, -b, -b, -b, -b];

%Hadamard
H0=1;
H1=[H0,H0;  H0,-H0];
H2=[H1,H1;  H1,-H1];
H3=[H2,H2;  H2,-H2];
H4=[H3,H3;  H3,-H3];
H5=[H4,H4;  H4,-H4];
H6=[H5,H5;  H5,-H5];
H7=[H6,H6;  H6,-H6];
H8=[H7,H7;  H7,-H7];

%hn
for n=1:16
    h(n,1:256)=H8(m(n)+1,1:256);
end
   
%ɸͬ
for n=1:16
    SSC(n,1:256)=(1+1i)*z.*h(n,1:256);
end

end